/*
 * Decompiled with CFR 0.152.
 */
package com.dfdyz.epicacg.client.render.pipeline;

import com.dfdyz.epicacg.client.render.pipeline.PostEffectPipelines;
import com.dfdyz.epicacg.client.render.targets.TargetManager;
import com.dfdyz.epicacg.registry.PostEffects;
import com.dfdyz.epicacg.utils.RenderUtils;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.pipeline.TextureTarget;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexSorting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;

public abstract class PostParticleRenderType
implements ParticleRenderType {
    private final ResourceLocation renderTypeID;
    private final ResourceLocation texture;
    static ResourceLocation tempTarget = new ResourceLocation("epicacg:depth_cull_temp");

    public PostParticleRenderType(ResourceLocation renderTypeID, ResourceLocation texture) {
        this.renderTypeID = renderTypeID;
        this.texture = texture;
    }

    public void m_6505_(BufferBuilder bufferBuilder, TextureManager textureManager) {
        RenderSystem.enableBlend();
        RenderSystem.disableCull();
        Minecraft.m_91087_().f_91063_.m_109154_().m_109896_();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.enableDepthTest();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.setShader(this::getShader);
        if (this.texture != null) {
            RenderUtils.GLSetTexture(this.texture);
        }
        this.getPipeline().start();
        this.setupBufferBuilder(bufferBuilder);
    }

    protected ShaderInstance getShader() {
        return GameRenderer.f_172588_;
    }

    public void callPipeline() {
        this.getPipeline().call();
    }

    public boolean tryCallPipeline() {
        if (!PostEffectPipelines.isActive()) {
            this.callPipeline();
            return true;
        }
        return false;
    }

    public void m_6294_(Tesselator tesselator) {
        tesselator.m_85915_().m_277127_(VertexSorting.f_276633_);
        tesselator.m_85914_();
        this.getPipeline().suspend();
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableCull();
    }

    public static RenderTarget createTempTarget(RenderTarget screenTarget) {
        TextureTarget rendertarget = new TextureTarget(screenTarget.f_83915_, screenTarget.f_83916_, true, Minecraft.f_91002_);
        rendertarget.m_83931_(0.0f, 0.0f, 0.0f, 0.0f);
        rendertarget.m_83954_(Minecraft.f_91002_);
        return rendertarget;
    }

    public void setupBufferBuilder(BufferBuilder bufferBuilder) {
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85820_);
    }

    public abstract PostEffectPipelines.Pipeline getPipeline();

    public static void doDepthCull(RenderTarget source, RenderTarget DepthBuffer) {
        RenderTarget tmp = TargetManager.getTarget(tempTarget);
        PostEffects.blit.process(source, tmp);
        PostEffects.depth_cull.process(tmp, DepthBuffer, source);
        TargetManager.ReleaseTarget(tempTarget);
    }

    public static void Blit(RenderTarget source, RenderTarget output) {
        PostEffects.blit.process(source, output, effect -> {});
    }

    public String toString() {
        return this.renderTypeID.toString();
    }
}

